<?php
function render_fields_form($pdo, $member_id = null, $lang='en'){
  $fields = $pdo->query('SELECT * FROM custom_fields ORDER BY sort_order')->fetchAll(PDO::FETCH_ASSOC);
  $values = [];
  if ($member_id) {
    $stmt = $pdo->prepare('SELECT field_id, field_value FROM member_field_values WHERE member_id=?'); $stmt->execute([$member_id]);
    foreach($stmt->fetchAll() as $r) $values[$r['field_id']] = $r['field_value'];
  }
  $html='';
  foreach($fields as $f){
    $lbl=json_decode($f['field_label'],true)[$lang] ?? json_decode($f['field_label'],true)['en'];
    $val = $values[$f['id']] ?? '';
    $name = 'field_'.$f['id'];
    $html .= "<div class='mb-3'><label>{$lbl}</label>";
    switch($f['field_type']){
      case 'text': $html .= "<input name='{$name}' class='form-control' value='".htmlspecialchars($val)."'>"; break;
      case 'email': $html .= "<input type='email' name='{$name}' class='form-control' value='".htmlspecialchars($val)."'>"; break;
      case 'number': $html .= "<input type='number' name='{$name}' class='form-control' value='".htmlspecialchars($val)."'>"; break;
      case 'date': $html .= "<input type='date' name='{$name}' class='form-control' value='".htmlspecialchars($val)."'>"; break;
      case 'textarea': $html .= "<textarea name='{$name}' class='form-control'>".htmlspecialchars($val)."</textarea>"; break;
      case 'dropdown':
        $opts = json_decode($f['options'],true)[$lang] ?? json_decode($f['options'],true)['en'] ?? [];
        $html .= "<select name='{$name}' class='form-select'>";
        foreach($opts as $o){ $sel = ($val==$o)?'selected':''; $html .= "<option value='".htmlspecialchars($o)."' $sel>".htmlspecialchars($o)."</option>"; }
        $html .= "</select>";
        break;
      case 'checkbox':
        $opts = json_decode($f['options'],true)[$lang] ?? json_decode($f['options'],true)['en'] ?? [];
        $vals = $val ? explode('||',$val) : [];
        foreach($opts as $o){ $chk = in_array($o,$vals)?'checked':''; $html .= "<div class='form-check'><input class='form-check-input' type='checkbox' name='{$name}[]' value='".htmlspecialchars($o)."' $chk><label class='form-check-label'>".htmlspecialchars($o)."</label></div>"; }
        break;
      case 'radio':
        $opts = json_decode($f['options'],true)[$lang] ?? json_decode($f['options'],true)['en'] ?? [];
        foreach($opts as $o){ $chk = ($val==$o)?'checked':''; $html .= "<div class='form-check'><input class='form-check-input' type='radio' name='{$name}' value='".htmlspecialchars($o)."' $chk><label class='form-check-label'>".htmlspecialchars($o)."</label></div>"; }
        break;
    }
    $html .= "</div>";
  }
  return $html;
}
?>