<?php
require_once __DIR__ . '/../lib/bootstrap.php';
// run daily via cron
$today = date('Y-m-d');
$stmt = $pdo->prepare('SELECT * FROM users WHERE subscription_active=1 AND next_due_date <= ?');
$stmt->execute([$today]);
while($m=$stmt->fetch(PDO::FETCH_ASSOC)){
  $mt = $pdo->prepare('SELECT * FROM membership_types WHERE id=?'); $mt->execute([$m['membership_type_id']]); $mp=$mt->fetch(PDO::FETCH_ASSOC);
  $amount = $mp['fee_amount'] ?? 0;
  $ins = $pdo->prepare('INSERT INTO invoices (member_id,membership_type_id,amount,currency,status,issued_at) VALUES (?,?,?,?,?,NOW())');
  $ins->execute([$m['id'],$mp['id'],$amount,getSetting('default_currency'),'unpaid']);
  $invoice_id = $pdo->lastInsertId();
  if($m['auto_renew_enabled'] && $m['payment_token']){
    // here you would call your gateway to charge the token. On success:
    // $pdo->prepare('UPDATE invoices SET status="paid", paid_at=NOW() WHERE id=?')->execute([$invoice_id]);
  }
}
echo "Done\n";
