<?php
require_once __DIR__ . '/../lib/bootstrap.php';
if (!isLogged() || currentUserRole()!=='superadmin') die('Access denied');
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $label_en = $_POST['label_en']; $label_ar = $_POST['label_ar']; $type = $_POST['type'];
  $options_en = $_POST['options_en'] ?? null; $options_ar = $_POST['options_ar'] ?? null;
  $opts = null;
  if (in_array($type,['dropdown','radio','checkbox'])) {
    $opts = json_encode(['en'=>array_map('trim',explode(',', $options_en)),'ar'=>array_map('trim',explode(',', $options_ar))]);
  }
  $name = strtolower(preg_replace('/[^a-z0-9_]+/','_', $label_en));
  $stmt = $pdo->prepare('INSERT INTO custom_fields (field_label, field_name, field_type, options, required, sort_order) VALUES (?,?,?,?,?,?)');
  $stmt->execute([json_encode(['en'=>$label_en,'ar'=>$label_ar]), $name, $type, $opts, (int)($_POST['required'] ?? 0), (int)($_POST['order'] ?? 0)]);
  setFlash('Field saved'); header('Location: fields.php'); exit;
}
$fields = $pdo->query('SELECT * FROM custom_fields ORDER BY sort_order')->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="p-4">
<h3>Manage Fields</h3>
<?php if($m=getFlash()): ?><div class="alert alert-success"><?php echo $m; ?></div><?php endif; ?>
<form method="post" class="mb-3">
<input name="label_en" placeholder="Label (EN)" class="form-control mb-1">
<input name="label_ar" placeholder="Label (AR)" class="form-control mb-1">
<select name="type" class="form-select mb-1">
<option value="text">Text</option><option value="textarea">Text Box</option><option value="email">Email</option>
<option value="phone">Phone</option><option value="number">Number</option>
<option value="dropdown">Dropdown</option><option value="checkbox">Checkbox</option><option value="radio">Radio</option>
<option value="date">Date</option>
</select>
<input name="options_en" class="form-control mb-1" placeholder="Options EN (comma separated)">
<input name="options_ar" class="form-control mb-1" placeholder="Options AR (comma separated)">
<label><input type="checkbox" name="required"> Required</label>
<input type="number" name="order" class="form-control mb-1" placeholder="Sort order">
<button class="btn btn-primary">Save Field</button>
</form>
<h4>Existing Fields</h4>
<ul class="list-group">
<?php foreach($fields as $f){ $label=json_decode($f['field_label'],true)['en']; echo "<li class='list-group-item'>{$label} ({$f['field_type']})</li>"; } ?>
</ul>
</body></html>
