<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_once __DIR__ . '/../lib/i18n.php';
if (!isLogged()) header('Location: login.php');
$role = currentUserRole(); $uid = currentUserId();
$membership_type_id = null;
if ($uid) { $r = $pdo->prepare('SELECT membership_type_id FROM users WHERE id=?'); $r->execute([$uid]); $membership_type_id = $r->fetchColumn(); }
$stmt = $pdo->prepare("SELECT w.*, v.pos_x, v.pos_y, v.width, v.height FROM dashboard_widgets w JOIN dashboard_visibility v ON w.id=v.widget_id WHERE v.role=? AND v.visible=1 ORDER BY v.pos_y, v.pos_x");
$stmt->execute([$role]); $widgets = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/gridstack@8.0.0/dist/gridstack.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/gridstack@8.0.0/dist/gridstack-all.js"></script>
<title>Dashboard</title></head>
<body>
<nav class="navbar navbar-expand bg-light p-2"><div class="container-fluid"><a class="navbar-brand" href="#">MMS</a>
<div class="d-flex"><a class="btn btn-outline-secondary me-2" href="logout.php">Logout</a></div></div></nav>
<div class="container-fluid mt-3"><div class="row"><div class="col-12">
<div class="grid-stack">
<?php foreach($widgets as $w):
  $title = json_decode($w['title'], true)[$_SESSION['lang'] ?? 'en'] ?? ($w['widget_key']);
  echo "<div class='grid-stack-item' data-gs-x='{$w['pos_x']}' data-gs-y='{$w['pos_y']}' data-gs-width='{$w['width']}' data-gs-height='{$w['height']}'><div class='grid-stack-item-content card p-2'><h5>$title</h5><div>Loading...</div></div></div>";
endforeach; ?>
</div></div></div></div>
<script>
  const grid = GridStack.init({cellHeight: 120});
</script>
</body></html>
