<?php
require_once __DIR__ . '/bootstrap.php';

function getDefaultLang() {
    global $pdo;
    $stmt = $pdo->query('SELECT default_language, languages_enabled FROM system_settings LIMIT 1');
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    return [$r['default_language'] ?? 'en', (bool)$r['languages_enabled']];
}

function loadTranslations($lang) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT word_key, translation FROM translations WHERE lang = ?');
    $stmt->execute([$lang]);
    return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
}

list($DEFAULT_LANG, $LANG_ENABLED) = getDefaultLang();
$lang = $_GET['lang'] ?? $_SESSION['lang'] ?? $DEFAULT_LANG;
$_SESSION['lang'] = $lang;
$TRANSLATIONS = loadTranslations($lang);
function t($k) { global $TRANSLATIONS; return $TRANSLATIONS[$k] ?? $k; }
?>